# I24 — No-Signalling (balanced blocks, deterministic control)
**PASS snapshot:** `2025-11-06T20-35-52Z`

This repo contains the exact engine and artifacts for the PASSed I24 run, plus wrappers to reproduce it.

## Contents
- `engine_i24_no_signalling.py` — engine (exact content from the specification)
- `runs/2025-11-06T20-35-52Z/` — PASS run with `config/`, `outputs/`, `logs/`
- `run_repro.py` — replays the PASS run (same manifest & outdir)
- `run_with_manifest.py` — runs with the PASS manifest into a new timestamped folder
- `scripts/` — shell helpers

## Reproduce the PASS run (overwrites files in place)
```bash
python run_repro.py --manifest runs/2025-11-06T20-35-52Z/config/manifest_i24.json --outdir runs/2025-11-06T20-35-52Z/
```
or
```bash
bash scripts/run_repro.sh
```

## Create a fresh run folder
```bash
python run_with_manifest.py
```
or
```bash
bash scripts/run_new.sh
```

## Requirements
- Python **3.8+**; **no external packages** required (stdlib only).
- Note: the engine's block check calls `any()` with a boolean; the wrappers temporarily accept
  this usage to match the environment used during the PASS run. The engine file itself is unchanged.
